/** \file defs.hpp
 * 
 * Constant definitons and enumerations.
 * 
 */

#ifndef DEFS_HPP_
#define DEFS_HPP_

using namespace std;

#define MYEPSILON 1e-13   //!< machine epsilon precision
#define NDIM  3   //!< number of spatial dimensions
#define MAX_ELEMENTS 128  //!< maximum number of elements for certain lookup tables 
#define AtomicLengthToAngstroem  0.52917721 //!< conversion factor from atomic length/bohrradius to angstroem
#define BONDTHRESHOLD 0.5   //!< CSD threshold in bond check which is the width of the interval whose center is the sum of the covalent radii 

#define VERSIONSTRING "v1.0"

enum BondOrderScheme { NoScheme, BottomUp, TopDown, ANOVA, Combined }; //!< Fragmentation scheme used in BOSS

enum EdgeType { Undetermined, TreeEdge, BackEdge }; //!< edge type in a graph after Depth-First-Search analysis.

enum Shading { white, lightgray, darkgray, black };  //!< color in Breadth-First-Search analysis

enum CutCyclicBond { KeepBond,  SaturateBond }; //!< Saturation scheme either atom- or bondwise 

// Specifting whether a value in the parameter file must be specified or is optional
enum necessity { optional,    //!< parameter is optional, if not given sensible value is chosen
                 critical     //!< parameter must be given or programme won't initiate
               };

// Specifying the status of the on command line given config file
enum ConfigStatus { absent, empty, present };

// Specifying the cast type to be read of a parameter, see ParseForParameter()
enum value_type { string_type, double_type, int_type, row_int, row_double, grid, lower_trigrid, upper_trigrid}; 

// various standard filenames
#define DEFAULTCONFIG "main_pcp_linux"
#define KEYSETFILE "KeySets.dat"
#define ADJACENCYFILE "Adjacency.dat"
#define TEFACTORSFILE "TE-Factors.dat"
#define FORCESFILE "Forces-Factors.dat"
#define FRAGMENTPREFIX "BondFragment"
#define STANDARDCONFIG "unknown.conf"
#define STANDARDELEMENTSDB "elements.db"
#define STANDARDVALENCEDB "valence.db"
#define STANDARDORBITALDB "orbitals.db"
#define STANDARDHBONDDISTANCEDB "Hbonddistance.db"
#define STANDARDHBONDANGLEDB "Hbondangle.db"


#endif /*DEFS_HPP_*/
