/*
 * ThermoStatContainer.hpp
 *
 *  Created on: 12.06.2010
 *      Author: heber
 */

#ifndef THERMOSTATCONTAINER_HPP_
#define THERMOSTATCONTAINER_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Thermostats/Thermostat.hpp"

class ConfigFileBuffer;

class ThermoStatContainer {
public:
  ThermoStatContainer();
  ~ThermoStatContainer();
  ThermostatTraits<Thermostat> *getTraitByName(const std::string name);
  Thermostat *makeByName(const std::string name,class ConfigFileBuffer * const fb);
  void makeActive(const std::string name,class ConfigFileBuffer * const fb);
  Thermostat *getActive() {
    return activeThermostat;
  }
  void chooseNone();

  Thermostat* activeThermostat;
  typedef std::map<std::string,ThermostatTraits<Thermostat>* > traitsMap;
  traitsMap availThermostats;
  double TargetTemp;
};

#endif /* THERMOSTATCONTAINER_HPP_ */
