/*
 * ThreeBodyPotential_AngleUnitTest.hpp
 *
 *  Created on: Oct 16, 2012
 *      Author: heber
 */

#ifndef THREEBODYPOTENTIAL_ANGLEUNITTEST_HPP_
#define THREEBODYPOTENTIAL_ANGLEUNITTEST_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <cppunit/extensions/HelperMacros.h>

#include "FunctionApproximation/FunctionModel.hpp"

class ThreeBodyPotential_Angle;

/********************************************** Test classes **************************************/

class ThreeBodyPotential_AngleTest : public CppUnit::TestFixture
{
    CPPUNIT_TEST_SUITE( ThreeBodyPotential_AngleTest) ;
    CPPUNIT_TEST ( operatorTest );
    CPPUNIT_TEST ( derivativeTest );
    CPPUNIT_TEST ( parameter_derivativeTest );
    CPPUNIT_TEST_SUITE_END();

public:
      void setUp();
      void tearDown();
      void operatorTest();
      void derivativeTest();
      void parameter_derivativeTest();

private:
      typedef std::vector<double> data_t;
      std::vector<FunctionModel::arguments_t> input;
      data_t output;
};

#endif /* THREEBODYPOTENTIAL_ANGLEUNITTEST_HPP_ */
