#ifndef PERIODENTAFEL_HPP_
#define PERIODENTAFEL_HPP_

/*********************************************** includes ***********************************/

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iosfwd>
#include <map>
#include <string>

#include "Helpers/defs.hpp"
#include "types.hpp"

#include "boost/serialization/array.hpp"
#include "boost/serialization/map.hpp"

/****************************************** forward declarations *****************************/

class element;

/********************************************** declarations *******************************/


/** Periodentafel is a list of all elements sorted by their atomic number.
 */
class periodentafel {
  /******* Types *********/
  friend class periodentafelTest;
private:
  typedef std::map<atomicNumber_t,element*> elementSet;
public:
  typedef elementSet::iterator iterator;
  typedef elementSet::const_iterator const_iterator;
  typedef std::reverse_iterator<const_iterator> reverse_iterator;

  /******* Functions *********/
public:
  periodentafel(const bool DoLoad = false);
  ~periodentafel();

  iterator AddElement(element * pointer);
  size_t RemoveElement(const element * pointer);
  size_t RemoveElement(atomicNumber_t);
  void CleanupPeriodtable();
  const element * FindElement(atomicNumber_t) const;
  const element * FindElement(const std::string &shorthand) const;
  const element * AskElement() const;
  const element * EnterElement();

  const_iterator begin() const;
  const_iterator end() const;
  reverse_iterator rbegin() const;
  reverse_iterator rend() const;
  bool Output(std::ostream * const output) const;
  void OutputElement(std::ostream * const output, const element *elem) const;
  bool LoadPeriodentafel(const char * const path);
  bool StorePeriodentafel(const char * const path) const;

  bool operator==(const periodentafel &other) const;

  bool operator!=(const periodentafel &other) const {
    return !(*this == other);
  }

private:
  friend class boost::serialization::access;
  // serialization
  template<class Archive>
  void serialize(Archive & ar, const unsigned int version)
  {
    ar & boost::serialization::make_array<char>(header1, MAXSTRINGSIZE);
    ar & boost::serialization::make_array<char>(header2, MAXSTRINGSIZE);
    ar & elements;
  }

  void ScanPeriodentafel();
  bool LoadColorDatabase(std::istream &input);
  bool LoadElementsDatabase(std::istream &input);
  bool LoadElectronegativityDatabase(std::istream &input);
  bool LoadValenceDatabase(std::istream &input);
  bool LoadOrbitalsDatabase(std::istream &input);
  bool LoadHBondAngleDatabase(std::istream &input);
  bool LoadHBondLengthsDatabase(std::istream &input);

  /******* Variables *********/
private:
  char header1[MAXSTRINGSIZE]; //!< store first header line
  char header2[MAXSTRINGSIZE]; //!< store second header line

  elementSet elements;
};

#endif /*PERIODENTAFEL_HPP_*/
