/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * NotAtomByIdAction.cpp
 *
 *  Created on: May 12, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "atom.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "Descriptors/AtomIdDescriptor.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

#include "NotAtomByIdAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "NotAtomByIdAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr SelectionNotAtomByIdAction::performCall() {
  // obtain information
  getParametersfromValueStorage();

  const atom * Walker = World::getInstance().getAtom(AtomById(params.WalkerId));
  if (Walker != NULL) {
    if (World::getInstance().isSelected(Walker)) {
      LOG(1, "Unselecting atom " << *Walker);
      World::getInstance().unselectAtom(Walker);
      LOG(0, World::getInstance().countSelectedAtoms() << " atoms remain selected.");
      return Action::state_ptr(new SelectionNotAtomByIdState(params));
    } else {
      return Action::success;
    }
  } else {
    return Action::failure;
  }
}

Action::state_ptr SelectionNotAtomByIdAction::performUndo(Action::state_ptr _state) {
  SelectionNotAtomByIdState *state = assert_cast<SelectionNotAtomByIdState*>(_state.get());

  const atom * Walker = World::getInstance().getAtom(AtomById(state->params.WalkerId));
  World::getInstance().selectAtom(Walker);

  return Action::state_ptr(_state);
}

Action::state_ptr SelectionNotAtomByIdAction::performRedo(Action::state_ptr _state){
  SelectionNotAtomByIdState *state = assert_cast<SelectionNotAtomByIdState*>(_state.get());

  const atom * Walker = World::getInstance().getAtom(AtomById(state->params.WalkerId));
  World::getInstance().unselectAtom(Walker);

  return Action::state_ptr(_state);
}

bool SelectionNotAtomByIdAction::canUndo() {
  return true;
}

bool SelectionNotAtomByIdAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
