/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * AtomByIdAction.cpp
 *
 *  Created on: May 12, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "atom.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "World.hpp"
#include "Descriptors/AtomIdDescriptor.hpp"

#include <iostream>
#include <string>

#include "AtomByIdAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "AtomByIdAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr SelectionAtomByIdAction::performCall() {
  // obtain information
  getParametersfromValueStorage();

  const atom *Walker = World::getInstance().getAtom(AtomById(params.WalkerId));
  if (Walker != NULL) {
    if (!World::getInstance().isSelected(Walker)) {
      LOG(1, "Selecting atom " << *Walker);
      World::getInstance().selectAtom(Walker);
      LOG(0, World::getInstance().countSelectedAtoms() << " atoms selected.");
      return Action::state_ptr(new SelectionAtomByIdState(params));
    } else {
      return Action::success;
    }
  } else {
    return Action::failure;
  }
}

Action::state_ptr SelectionAtomByIdAction::performUndo(Action::state_ptr _state) {
  SelectionAtomByIdState *state = assert_cast<SelectionAtomByIdState*>(_state.get());

  const atom *Walker = World::getInstance().getAtom(AtomById(state->params.WalkerId));
  World::getInstance().unselectAtom(Walker);

  return Action::state_ptr(_state);
}

Action::state_ptr SelectionAtomByIdAction::performRedo(Action::state_ptr _state){
  SelectionAtomByIdState *state = assert_cast<SelectionAtomByIdState*>(_state.get());

  const atom *Walker = World::getInstance().getAtom(AtomById(state->params.WalkerId));
  World::getInstance().selectAtom(Walker);

  return Action::state_ptr(_state);
}

bool SelectionAtomByIdAction::canUndo() {
  return true;
}

bool SelectionAtomByIdAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
