/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * SetRandomNumbersDistribution.cpp
 *
 *  Created on: Jan 01, 2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "CodePatterns/Log.hpp"
#include "molecule.hpp"
#include "CodePatterns/Verbose.hpp"
#include "World.hpp"

#include "RandomNumbers/RandomNumberDistributionFactory.hpp"
#include "RandomNumbers/RandomNumberDistribution.hpp"
#include "RandomNumbers/RandomNumberDistribution_Parameters.hpp"

#include <iostream>
#include <fstream>
#include <string>

#include "SetRandomNumbersDistributionAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "SetRandomNumbersDistributionAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr CommandSetRandomNumbersDistributionAction::performCall() {
  // obtain information
  getParametersfromValueStorage();

  // note down old type
  std::string oldtype = RandomNumberDistributionFactory::getInstance().getCurrentTypeName();
  LOG(1, "Current distribution is " << oldtype);

  // set the new default
  RandomNumberDistributionFactory::getInstance().setCurrentType(params.distribution_type);
  LOG(0, "STATUS: Distribution of random number generator is now: "
      << RandomNumberDistributionFactory::getInstance().getCurrentTypeName());

  // note down old parameters
  RandomNumberDistribution_Parameters *oldparameters =
      RandomNumberDistributionFactory::getInstance().getPrototype().getParameterSet();
  // set each parameter (that is not -1);
  if (!params.parameters.isDefault()) {
    RandomNumberDistribution_Parameters *currentparameters =
        RandomNumberDistributionFactory::getInstance().getPrototype().getParameterSet();
    currentparameters->update(params.parameters);
    LOG(1, "INFO: Changing prototype's parameters to " << params.parameters << ".");
    RandomNumberDistributionFactory::getInstance().manipulatePrototype(*currentparameters);
    delete currentparameters;
  }

  {
    RandomNumberDistribution_Parameters *currentparameters =
        RandomNumberDistributionFactory::getInstance().getPrototype().getParameterSet();
    LOG(1, "Its parameters are: " << *currentparameters);
    delete  currentparameters;
  }

  CommandSetRandomNumbersDistributionState *newstate =
      new CommandSetRandomNumbersDistributionState(oldtype,*oldparameters,params);
  delete oldparameters;
  return Action::state_ptr(newstate);
}

Action::state_ptr CommandSetRandomNumbersDistributionAction::performUndo(Action::state_ptr _state) {
  CommandSetRandomNumbersDistributionState *state = assert_cast<CommandSetRandomNumbersDistributionState*>(_state.get());

  // note down old type for redo
  std::string newtype = RandomNumberDistributionFactory::getInstance().getCurrentTypeName();
  LOG(1, "Newly set distribution was " << newtype);

  // note down old parameters for redo
  RandomNumberDistribution_Parameters *newparameters =
      RandomNumberDistributionFactory::getInstance().getPrototype().getParameterSet();

  // set the new default
  RandomNumberDistributionFactory::getInstance().setCurrentType(state->old_distribution_type);
  LOG(0, "STATUS: Distribution of random number generator is again: "
      << RandomNumberDistributionFactory::getInstance().getCurrentTypeName());

  // set each parameter back (that is not -1);
  if (!state->old_parameters.isDefault()) {
    LOG(1, "INFO: Changing back prototype's parameters to " << state->old_parameters << ".");
    RandomNumberDistributionFactory::getInstance().manipulatePrototype(state->old_parameters);
  }

  {
    RandomNumberDistribution_Parameters *currentparameters =
        RandomNumberDistributionFactory::getInstance().getPrototype().getParameterSet();
    LOG(1, "Its parameters are: " << *currentparameters);
    delete  currentparameters;
  }

  CommandSetRandomNumbersDistributionState *newstate =
      new CommandSetRandomNumbersDistributionState(newtype,*newparameters,params);
  delete newparameters;
  return Action::state_ptr(newstate);
}

Action::state_ptr CommandSetRandomNumbersDistributionAction::performRedo(Action::state_ptr _state){
  return performUndo(_state);
}

bool CommandSetRandomNumbersDistributionAction::canUndo() {
  return true;
}

bool CommandSetRandomNumbersDistributionAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
