/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * TxMenuLeaveAction.cpp
 *
 *  Created on: Nov 8, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Actions/Action.hpp"
#include "Actions/ActionQueue.hpp"
#include "Actions/ActionTrait.hpp"
#include "Menu/TextMenu/TxMenuLeaveAction.hpp"
#include "CodePatterns/Assert.hpp"

using namespace MoleCuilder;

/** Constructor for class TxMenu::LeaveAction.
 * \param _menu pointer to the containing TxMenu
 * \param &LeaveActionTrait ActionTrait for this Action
 */
TxMenu::LeaveAction::LeaveAction(TxMenu* const _menu, const ActionTrait & LeaveActionTrait) :
  Action(LeaveActionTrait),
  menu(_menu)
{}

/** Destructor for class TxMenu::LeaveAction.
 *
 */
TxMenu::LeaveAction::~LeaveAction(){}

/** We can't undo the leave action.
 * \return false
 */
bool TxMenu::LeaveAction::canUndo(){
  return false;
}

/** We should never undo the leave action.
 * \return false
 */
bool TxMenu::LeaveAction::shouldUndo(){
  return false;
}

void TxMenu::LeaveAction::outputAsCLI(std::ostream &ost) const
{}

/** Internal function to construct the dialog.
 * We do not need this function as there is no dialog to construct.
 */
Dialog* TxMenu::LeaveAction::fillDialog(Dialog *dialog){
  ASSERT(dialog,"No Dialog given when filling action dialog");
  return dialog;
}

/** Calls TxMenu::doQuit() on the stored menu reference.
 * \return ActionState pointer with success
 */
ActionState::ptr TxMenu::LeaveAction::performCall(){
  menu->doQuit();
  return Action::success;
}

/** Implementation of undo function for an Action.
 * We do not use this functionality.
 * \return ActionState pointer with failure
 */
ActionState::ptr TxMenu::LeaveAction::performUndo(ActionState::ptr){
  ASSERT(0,"Cannot undo leaving a menu");
  return Action::failure;
}

/** Implementation of redo function for an Action.
 * We do not use this functionality.
 * \return ActionState pointer with failure
 */
ActionState::ptr TxMenu::LeaveAction::performRedo(ActionState::ptr){
  ASSERT(0,"Cannot redo leaving a menu");
  return Action::failure;
}
