/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2017 Frederik Heber. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * GeometryNameValidator.cpp
 *
 *  Created on: Mar 27, 2017
 *      Author: heber
 */


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

//#include "CodePatterns/MemDebug.hpp"

#include "GeometryNameValidator.hpp"

#include <boost/lexical_cast.hpp>

#include "Geometry/GeometryRegistry.hpp"

bool GeometryNameValidator::isValid(const std::string & _value) const
{
  // must not contain comma
  bool status = (_value.find(",") == std::string::npos);

  // must not contain white space
  status &= (_value.find(" ") == std::string::npos);
  status &= (_value.find("\t") == std::string::npos);

  // must not contain digits only
  if (status) {
    status = false;
    double tmp = 0.;
    try {
      tmp = boost::lexical_cast<double>(_value);
    } catch(boost::bad_lexical_cast &e) {
      status = true;
    }
  }

  return status;
}

bool GeometryNameValidator::operator==(const Validator<std::string> &_instance) const
{
  const GeometryNameValidator *inst =
      dynamic_cast<const GeometryNameValidator *>(&_instance);
  if (inst)
    return true;
  else
    return false;
}

Validator< std::string >* GeometryNameValidator::clone() const
{
  Validator< std::string > *inst =
      new GeometryNameValidator();
  return inst;
}
