#ifndef defs_h
#define defs_h

/** \file defs.h
 * Physical dimensions and other constants.
 * 
 * Herein is defined the smallest possible number unequal zero MYEPSILON, the bohr radius in
 * atmic units BOHRRADIUS, the number of dimensions NDIM or the number of standard level
 * STANDARTLEVEL or how long a string at the very most may be MAXDUMMYSTRING
 * 
  Project: ParallelCarParrinello
  Jan Hamaekers
  2000

  File: defs.h
  $Id: defs.h,v 1.13 2007-03-29 13:35:22 foo Exp $
*/

#include <float.h>
#define MYEPSILON (DBL_EPSILON*1000.0)	//!< 1000 times the smallest possible constant (1.0+DBL_EPSILON!=1.0)
#define RTCOEFFFACTOR 0.0		//!< RT(?) Koeffizientenfaktor
#define ANGSTROEMINBOHRRADIUS 1.8897261 //!< Bohr radius in Angstroem - units 1.74 */

#define STANDARTLEVEL 1		//!< standard level depth

#define NDIM (3)	//!< spatial dimensions
#define NDIM_NDIM (NDIM*NDIM)		//!< spatial squared

#define MAXDUMMYSTRING (199)	//!< maximum length when mallocting space for string

//#define mu0 6.691762496807159e-04 //!< permeability of the vacuum in atomic units (a_0 m_e e^{-2}, converted from CODATA values)
//#define mu0 0.0006691762496807159
#define mu0 (12.566370614e-7/8.2387225e-8*(6.62361782e-3*6.62361782e-3)) //!< permeability of the vacuum in atomic units (a_0 m_e e^{-2}, converted from CODATA values)

#define loschmidt_constant (2.6867773e25*(0.5291772108e-10*0.5291772108e-10*0.5291772108e-10)) //! Loschmidt's constant in atomic units
//#define loschmidt_constant 0.00268262 

#define KelvinToAtomicTemperature 3.1668152e-06    //!< conversion factor for Kelvin to atomic temperature (Hartree over k_B)
#define KelvinToeV 8.6173422e-05                   //!< conversion factor for Kelvin to Ht (k_B * T = energy), thus Boltzmann constant in eV/K
#define AtomicMassUnitsToeV 931494088.        //!< conversion factor for atomic weight in units to mass in eV
#define AtomicMassUnitsToHt 34480864.        //!< conversion factor for atomic weight in units to mass in Ht (protonmass/electronmass * electron_mass_in_Ht
#define ElectronMass_Ht 18778.865            //!< electron mass in Ht
#define ElectronMass_eV 510998.903           //!< electron mass in eV
#define Units2Electronmass (AtomicMassUnitsToeV/ElectronMass_eV) //!< atomic mass unit in eV/ electron mass in eV = 1 822.88863
#define Atomictime2Femtoseconds 0.024188843     //!< Atomictime in fs

#endif
