/*
 * HelpAction.cpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/CmdAction/HelpAction.hpp"
#include "Actions/ActionRegistry.hpp"
#include "CommandLineParser.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/ValueStorage.hpp"

const char CommandLineHelpAction::NAME[] = "help";

CommandLineHelpAction::CommandLineHelpAction() :
  Action(NAME)
{}

CommandLineHelpAction::~CommandLineHelpAction()
{}

void CommandHelp() {
  ActionRegistry::getInstance().getActionByName(CommandLineHelpAction::NAME)->call(Action::NonInteractive);
};

Dialog* CommandLineHelpAction::fillDialog(Dialog *dialog) {
  ASSERT(dialog,"No Dialog given when filling action dialog");

  ostringstream usage;
  usage << CommandLineParser::getInstance().visible << endl;
  dialog->queryEmpty(NAME, usage.str());

  return dialog;
}

Action::state_ptr CommandLineHelpAction::performCall() {
  return Action::success;
}

Action::state_ptr CommandLineHelpAction::performUndo(Action::state_ptr _state) {
  return Action::success;
}

Action::state_ptr CommandLineHelpAction::performRedo(Action::state_ptr _state){
  return Action::success;
}

bool CommandLineHelpAction::canUndo() {
  return true;
}

bool CommandLineHelpAction::shouldUndo() {
  return false;
}

const string CommandLineHelpAction::getName() {
  return NAME;
}
