/*
 * QtShapeList.h
 *
 *  Created on: Sep 14, 2012
 *      Author: ankele
 */

#ifndef QTSHAPELIST_H_
#define QTSHAPELIST_H_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <QtGui/QTreeWidget>
#include "CodePatterns/Observer/Observer.hpp"

class Shape;

class QtShapeList: public QTreeWidget, public Observer
{
  Q_OBJECT

public:
  QtShapeList(QWidget * _parent=0);
  virtual ~QtShapeList();

protected:
  virtual void update(Observable *publisher);
  virtual void subjectKilled(Observable *publisher);
  //virtual void paintEvent(QPaintEvent * event);
  void refill();

  static const int COLUMNCOUNT;
  enum {NAME,TYPE,CENTER,RADIUS,COLUMNTYPES_MAX} COLUMNTYPES;
  static const char *COLUMNNAMES[];

private slots:
  void rowSelected();

/*signals:
  void moleculeSelected(molecule*);
  void moleculeUnSelected(molecule*);
  void changed();*/

private:
  std::vector<bool> shapeSelection; //!< needed to determine when a selection changes
};

#endif /* QTSHAPELIST_H_ */
