/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 *
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * QtShapeList.cpp
 *
 *  Created on: Sep 14, 2012
 *      Author: ankele
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Views/Qt4/QtShapeList.hpp"

#include <iostream>

#include "CodePatterns/MemDebug.hpp"

#include "Shapes/ShapeFactory.hpp"
#include "Shapes/ShapeRegistry.hpp"

#include <QAbstractItemView>
//#include "Actions/SelectionAction/Atoms/AtomByElementAction.hpp"
//#include "Actions/SelectionAction/Atoms/NotAtomByElementAction.hpp"

using namespace std;

const int QtShapeList::COLUMNCOUNT = COLUMNTYPES_MAX;
const char *QtShapeList::COLUMNNAMES[QtShapeList::COLUMNCOUNT]={"Name","Type","Center","Radius"};

QtShapeList::QtShapeList(QWidget * _parent) :
    QTreeWidget (_parent),
    Observer("QtShapeList")
{
  setColumnCount(COLUMNCOUNT);
  setSelectionMode(QAbstractItemView::MultiSelection);

  QStringList header;
	for(int i=0; i<COLUMNCOUNT;++i)
	  header << COLUMNNAMES[i];
	setHeaderLabels(header);

	refill();

	ShapeRegistry::getInstance().signOn(this);

  //connect(this,SIGNAL(itemSelectionChanged()),this,SLOT(rowSelected()));
  //connect(this,SIGNAL(changed()),this,SLOT(update()));
}

QtShapeList::~QtShapeList()
{
  ShapeRegistry::getInstance().signOff(this);
}

void QtShapeList::update(Observable *publisher) {

  refill();
}

void QtShapeList::refill() {

  clear();

  ShapeRegistry &reg = ShapeRegistry::getInstance();
  ShapeFactory &factory = ShapeFactory::getInstance();

  ShapeRegistry::const_iterator iter;
  for (iter = reg.getBeginIter(); iter != reg.getEndIter(); iter ++){
    ::Shape *s = iter->second;

    QTreeWidgetItem *treeItem = new QTreeWidgetItem(this);
    treeItem->setText(NAME, QString(s->getName().c_str()));
    treeItem->setText(TYPE, QString(factory.getShapeName(s->getType()).c_str()));
    treeItem->setText(CENTER, QString(toString(s->getCenter()).c_str()));
    treeItem->setText(RADIUS, QString::number(s->getRadius()));
  }
}

#if 0
void QtShapeList::paintEvent(QPaintEvent * event)
{
  /*if (dirty)
    refill();*/
  QtShapeList::paintEvent(event);
}
#endif

void QtShapeList::subjectKilled(Observable *publisher) {
}


void QtShapeList::rowSelected()
{
  //std::cout << "rowSelected\n";
  /*periodentafel *&periode = World::getInstance().getPeriode();

  for (int i=0;i<topLevelItemCount();i++){
    QTreeWidgetItem *item = topLevelItem(i);
    bool newSelection = item->isSelected();
    if (newSelection != elementSelection[i]){
      elementSelection[i] = newSelection;

      int atomicNumber = item->text(NUMBER).toInt();
      const element *e = periode->FindElement(atomicNumber);
      if (newSelection)
        MoleCuilder::SelectionAtomByElement(e);
      else
        MoleCuilder::SelectionNotAtomByElement(e);
    }
  }*/
}

