/** \file menu.hpp
 * The class in this file is responsible for displaying the menu and enabling choices.
 *
 * This class is currently being refactored. Functions were copied from builder.cpp and are
 * to be imported into the menu class.
 *
 */

#ifndef MENU_H_
#define MENU_H_


class MoleculeListClass;
class periodentafel;
class config;
class molecule;

class oldmenu
{
public:
  oldmenu();
  virtual ~oldmenu();

  // methods taken from ManipulateMoleculse submenu
  void duplicateCell(MoleculeListClass *molecules, config *configuration);

  // methods taken from MergeMolecules submenu
  void SimpleAddMolecules(MoleculeListClass *molecules);
  void embeddMolecules(MoleculeListClass *molecules);
  void multiMergeMolecules(MoleculeListClass *molecules);
  void simpleMergeMolecules(MoleculeListClass *molecules);

  void AddAtoms(periodentafel *, molecule *);
  void AlignAtoms(periodentafel *, molecule *);
  void CenterAtoms(molecule *);
  void FragmentAtoms(molecule *, config *);
  void ManipulateAtoms(periodentafel *, MoleculeListClass *, config *);
  void MeasureAtoms(periodentafel *, molecule *, config *);
  void MergeMolecules(periodentafel *, MoleculeListClass *);
  void ManipulateMolecules(periodentafel *, MoleculeListClass *, config *);
  void MirrorAtoms(molecule *);
  void RemoveAtoms(molecule *);
  void testroutine(MoleculeListClass *);
};

#endif /* MENU_H_ */
