/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * RemoveAction.cpp
 *
 *  Created on: May 9, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Actions/UndoRedoHelpers.hpp"
#include "Atom/atom.hpp"
#include "Atom/AtomicInfo.hpp"
#include "Descriptors/AtomDescriptor.hpp"
#include "CodePatterns/Log.hpp"
#include "molecule.hpp"
#include "CodePatterns/Verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

#include "Actions/AtomAction/RemoveAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "RemoveAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr AtomRemoveAction::performCall() {
  // create undo state
  std::vector<AtomicInfo> Walkers;
  for (World::AtomSelectionConstIterator iter = World::getInstance().beginAtomSelection();
      iter != World::getInstance().endAtomSelection();
      ++iter) {
    Walkers.push_back(AtomicInfo(*(iter->second)));
  }
  AtomRemoveState *UndoState = new AtomRemoveState(Walkers, params);

  // remove all selected atoms
  for (World::AtomSelectionConstIterator iter = World::getInstance().beginAtomSelection();
      iter != World::getInstance().endAtomSelection();
      iter = World::getInstance().beginAtomSelection()) {
    LOG(1, "Removing atom " << (iter->second)->getId() << ".");
    World::getInstance().destroyAtom((iter->second));
  }
  return Action::state_ptr(UndoState);
}

Action::state_ptr AtomRemoveAction::performUndo(Action::state_ptr _state) {
  AtomRemoveState *state = assert_cast<AtomRemoveState*>(_state.get());

  // add all removed atoms again
  if (AddAtomsFromAtomicInfo(state->Walkers))
    return Action::state_ptr(_state);
  else
    return Action::failure;
}

Action::state_ptr AtomRemoveAction::performRedo(Action::state_ptr _state){
  AtomRemoveState *state = assert_cast<AtomRemoveState*>(_state.get());

  // simple remove again all previously added atoms
  RemoveAtomsFromAtomicInfo(state->Walkers);

  return Action::state_ptr(_state);
}

bool AtomRemoveAction::canUndo() {
  return true;
}

bool AtomRemoveAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
