/*
 * World.hpp
 *
 *  Created on: Feb 3, 2010
 *      Author: crueger
 */

#ifndef WORLD_HPP_
#define WORLD_HPP_

#include <boost/thread.hpp>

#include "Patterns/Observer.hpp"
#include "Patterns/Cacheable.hpp"

// forward declarations
class periodentafel;
class MoleculeListClass;
class atom;

class World : public Observable
{
public:

  /***** getter and setter *****/
  periodentafel* getPeriode();
private:
  periodentafel *periode;


  /***** singleton Stuff *****/
public:
  static World* get();
  static void destroy();
  static World* reset();

private:
  World();
  virtual ~World();

  static World *theWorld;
  // this mutex only saves the singleton pattern...
  // use other mutexes to protect internal data as well
  // this mutex handles access to the pointer, not to the object!!!
  static boost::mutex worldLock;

  /*****
   * some legacy stuff that is include for now but will be removed later
   *****/
public:
  MoleculeListClass *getMolecules();

  // functions used for the WorldContent template mechanism
  void registerContent(atom *theAtom);
private:
  MoleculeListClass *molecules;
};

#endif /* WORLD_HPP_ */
