/*
 * World.cpp
 *
 *  Created on: Feb 3, 2010
 *      Author: crueger
 */

#include "World.hpp"

#include <iostream>

/******************************* getter and setter ************************/
periodentafel* World::getPeriode(){
  return periode;
}

/******************************* Singleton Stuff **************************/

// TODO: Hide boost-thread using Autotools stuff when no threads are used
World* World::theWorld = 0;
boost::mutex World::worldLock;



World::World()
{}

World::~World()
{}

World* World::get(){
  // boost supports RAII-Style locking, so we don't need to unlock
  boost::mutex::scoped_lock guard(worldLock);
  if(!theWorld) {
    theWorld = new World();
  }
  return theWorld;
}

void World::destroy(){
  // boost supports RAII-Style locking, so we don't need to unlock
  boost::mutex::scoped_lock guard(worldLock);
  delete theWorld;
  theWorld = 0;
}

World* World::reset(){
  World* oldWorld = 0;
  {
    // boost supports RAII-Style locking, so we don't need to unlock
    boost::mutex::scoped_lock guard(worldLock);

    oldWorld = theWorld;
    theWorld = new World();
    // oldworld does not need protection any more,
    // since we should have the only reference

    // worldLock handles access to the pointer,
    // not to the object
  } // scope-end releases the lock

  // we have to let all the observers know that the
  // oldWorld was destroyed. oldWorld calls subjectKilled
  // upon destruction. Every Observer getting that signal
  // should see that it gets the updated new world
  delete oldWorld;
}

/******************************* deprecated Legacy Stuff ***********************/

MoleculeListClass *World::getMolecules() {
  return molecules;
}


// methods for WorldContent CRTP mechanism
void World::registerContent(atom *atom){
  std::cout << "############### some kind of Atom created ##################" << std::endl;
}
