/*
 * QtStatusBar.hpp
 *
 *  Created on: Feb 17, 2010
 *      Author: crueger
 */

#ifndef QTSTATUSBAR_HPP_
#define QTSTATUSBAR_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <map>
#include <utility>
#include <string>
#include <QtGui/QStatusBar>

#include "CodePatterns/Observer/Observer.hpp"

class QLabel;
class QProgressBar;
class QBoxLayout;

namespace MoleCuilder {
  class Process;
}

class QtStatusBar : public QStatusBar, public Observer
{
  Q_OBJECT

  struct progressIndicator{
    progressIndicator(const std::string &name);
    ~progressIndicator();
    QLabel *label;
    QProgressBar *bar;
    QBoxLayout *layout;
    QWidget *container;
  };
public:
  QtStatusBar(QWidget *parent=0);
  virtual ~QtStatusBar();

  void update(Observable *subject);
  void subjectKilled(Observable *subject);

private slots:
  void updateProgressBar(
      const std::string name,
      const unsigned int maxsteps,
      const unsigned int currentstep,
      const bool StopStatus);

signals:
  void redrawProgressBar(
      const std::string name,
      const unsigned int maxsteps,
      const unsigned int currentstep,
      const bool StopStatus);

private:
  void redrawStatus();

  int atomCount;
  int moleculeCount;

  QLabel *statusLabel;
  QWidget *parent;
  typedef std::map<std::string,progressIndicator*> progressBars_t;
  progressBars_t progressBars;
  std::string activeProcess;
};

#endif /* QTSTATUSBAR_HPP_ */
