/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * SetParserParametersAction.cpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "Parser/FormatParserStorage.hpp"
#include "Parser/MpqcParser.hpp"
#include "Parser/MpqcParser_Parameters.hpp"
#include "Actions/ValueStorage.hpp"

#include <iostream>
#include <string>

#include "SetParserParametersAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "SetParserParametersAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr ParserSetParserParametersAction::performCall() {
  // get parameters
  getParametersfromValueStorage();

  // get parser
  ParserTypes type = FormatParserStorage::getInstance().getTypeFromName(params.parsername);
  FormatParser_Parameters *parameters = FormatParserStorage::getInstance().get(type).parameters;
  ASSERT(parameters != NULL,
      "ParserSetParserParametersAction::performCall() - parameters of parser is NULL.");

  // obtain undo state
  std::stringstream oldparamstream;
  oldparamstream << *parameters;

  // obtain information
  std::stringstream newparamstream(params.newparams);
  newparamstream >> *parameters;

  return Action::state_ptr(new ParserSetParserParametersState(oldparamstream.str(), params));
}

Action::state_ptr ParserSetParserParametersAction::performUndo(Action::state_ptr _state) {
  ParserSetParserParametersState *state = assert_cast<ParserSetParserParametersState*>(_state.get());

  ParserTypes type = FormatParserStorage::getInstance().getTypeFromName(state->params.parsername);
  FormatParser_Parameters *parser = FormatParserStorage::getInstance().get(type).parameters;
  std::stringstream oldparamstream(state->oldparams);
  oldparamstream >> *parser;

  return Action::state_ptr(_state);
}

Action::state_ptr ParserSetParserParametersAction::performRedo(Action::state_ptr _state){
  ParserSetParserParametersState *state = assert_cast<ParserSetParserParametersState*>(_state.get());

  ParserTypes type = FormatParserStorage::getInstance().getTypeFromName(state->params.parsername);
  FormatParser_Parameters *parser = FormatParserStorage::getInstance().get(type).parameters;
  std::stringstream newparamstream(state->params.newparams);
  newparamstream >> *parser;

  return Action::state_ptr(_state);
}

bool ParserSetParserParametersAction::canUndo() {
  return true;
}

bool ParserSetParserParametersAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
