/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * HelpAction.cpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include <iostream>
#include <string>

#include "Actions/ActionRegistry.hpp"
#include "Actions/ActionTraits.hpp"
#include "Actions/OptionRegistry.hpp"
#include "Actions/OptionTrait.hpp"
#include "CodePatterns/Log.hpp"

#include "Actions/CommandAction/HelpAction.hpp"

// and construct the stuff
#include "HelpAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr CommandHelpAction::performCall() {
  // obtain information
  getParametersfromValueStorage();

  // print some general advice
  std::cout << std::endl << std::endl << "Usage help:" << std::endl;
  std::cout << "================================================================================" << std::endl;
  std::cout << "Usage: molecuilder --<action name> [arguments] [--<option1 name> <argument> ...]" << std::endl;
  std::cout << std::endl;
  std::cout << "MoleCuilder can do all kinds of measurements and manipulations and it always"  << std::endl;
  std::cout << "works on files! See action 'input' and 'set-output' on how to specify these." << std::endl;
  std::cout << std::endl;
  std::cout << "To get a list of all actions, use " << std::endl;
  std::cout << "\t'molecuilder --help'." << std::endl;
  std::cout << "To get all options for a specific action, use " << std::endl;
  std::cout << "\t'molecuilder --help --actionname \"<actionname>\"'." << std::endl;
  std::cout << std::endl;
  std::cout << "Arguments are given in the following (peculiar) ways:" << std::endl;
  std::cout << "\t - Boolean: give as 0 (false) or 1 (true)." << std::endl;
  std::cout << "\t - Integer: give as e.g. 17" << std::endl;
  std::cout << "\t - Double: give as e.g. 0.5346" << std::endl;
  std::cout << "\t - String: give as e.g. \"test\"" << std::endl;
  std::cout << "\t - List/vector of strings: gives as \"first\" \"second\" \"third\"." << std::endl;
  std::cout << "\t - Vector: give as \"x,y,z\", i.e. its 3 components." << std::endl;
  std::cout << "\t - Domain: give as \"xx,yx,yy,zx,zy,zz\", i.e. symmetric 3x3 matrix." << std::endl;
  std::cout << "\t - Path/filename: give as \"<path/filename>\"." << std::endl;
  std::cout << "================================================================================" << std::endl;
  std::cout << std::endl;
  // print list of actions or its options
  if (params.actionname == "none") {
    // print list of all Actions
    std::cout << "Here is a list of all available Actions:" << std::endl;
    for(ActionRegistry::const_iterator iter = ActionRegistry::getInstance().getBeginIter();
        iter != ActionRegistry::getInstance().getEndIter();
        ++iter) {
      const Action *instance = iter->second;
      std::cout << "'" << iter->first << "': \t "
          << instance->Traits.getDescription() << std::endl;
    }
  } else {
    // retrieve command from Registry and print its help
    if (ActionRegistry::getInstance().isActionPresentByName(params.actionname)) {
      const Action *instance = ActionRegistry::getInstance().getActionByName(params.actionname);
      // else give description of Action and its option value if present
      std::cout << instance->help();
      std::cout << std::endl;
      std::cout << std::endl;
    } else {
      ELOG(1, "No action is known by the name " << params.actionname << ".");
      return Action::failure;
    }

  }

  return Action::success;
}

Action::state_ptr CommandHelpAction::performUndo(Action::state_ptr _state) {
  return Action::success;
}

Action::state_ptr CommandHelpAction::performRedo(Action::state_ptr _state){
  return Action::success;
}

bool CommandHelpAction::canUndo() {
  return true;
}

bool CommandHelpAction::shouldUndo() {
  return false;
}
/** =========== end of function ====================== */
