/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * IntTextQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include <iostream>

#include "TextUI/Query/TextQuery.hpp"

#include "Helpers/Log.hpp"
#include "Helpers/Verbose.hpp"


TextDialog::IntTextQuery::IntTextQuery(string title, std::string _description) :
    Dialog::IntQuery(title,_description)
{}

TextDialog::IntTextQuery::~IntTextQuery() {}

bool TextDialog::IntTextQuery::handle() {
  bool badInput = false;
  do{
    badInput = false;
    std::cout << getDescription() << ": ";
    std::cin >> tmp;
    if(std::cin.fail()){
      badInput=true;
      std::cin.clear();
      std::cin.ignore(std::numeric_limits<streamsize>::max(),'\n');
      std::cout << "Input was not a number!" << std::endl;
    }
  } while(badInput);
  // clear the input buffer of anything still in the line
  std::cin.ignore(std::numeric_limits<streamsize>::max(),'\n');
  return true;
}

