/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2011 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * AtomOfMoleculeSelectionDescriptor.cpp
 *
 *  Created on: Dec 11, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Descriptors/AtomOfMoleculeSelectionDescriptor.hpp"
#include "Descriptors/AtomOfMoleculeSelectionDescriptor_impl.hpp"

#include "molecule.hpp"

#include "Helpers/helpers.hpp"


AtomOfMoleculeSelectionDescriptor_impl::AtomOfMoleculeSelectionDescriptor_impl(){}

AtomOfMoleculeSelectionDescriptor_impl::~AtomOfMoleculeSelectionDescriptor_impl(){}

bool AtomOfMoleculeSelectionDescriptor_impl::predicate(std::pair<atomId_t,atom*> atom){
  return World::getInstance().isSelected(atom.second->getMolecule());
}

atom* AtomOfMoleculeSelectionDescriptor_impl::find(){
  World &instance = World::getInstance();
  for (World::MoleculeSelectionIterator iter = instance.beginMoleculeSelection();
      iter != instance.endMoleculeSelection();
      ++iter) {
    if (iter->second->begin() != iter->second->end())
      return *(iter->second->begin());
  }
  return 0;
}

std::vector<atom*> AtomOfMoleculeSelectionDescriptor_impl::findAll(){
  std::vector<atom*> res;
  World &instance = World::getInstance();
  for (World::MoleculeSelectionIterator iter = instance.beginMoleculeSelection();
      iter != instance.endMoleculeSelection();
      ++iter) {
    std::copy(iter->second->begin(), iter->second->end(), res.begin());
  }
  return res;
}

AtomDescriptor AtomsByMoleculeSelection(){
  return AtomDescriptor(AtomDescriptor::impl_ptr(new AtomOfMoleculeSelectionDescriptor_impl()));
}
