/*
 * Channels.hpp
 *
 *  Created on: Dec 1, 2011
 *      Author: heber
 */

#ifndef CHANNELS_HPP_
#define CHANNELS_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <map>

#include "CodePatterns/Observer/defs.hpp"

class Observable;
class Relay;

/** Channels aggregate all possible Notifications of an Observable.
 *
 * Usually, one implements an enumeration of the channel number which is
 * visible to the outside only.
 *
 * \note Channels::subjectKilled() needs to be called by owning Observable.
 * It is passed on to Notification such that Observer that have only signed
 * on to single channel still know when their observable has died.
 */
class Channels {
public:
  Channels();
  virtual ~Channels();

  void addChannel(size_t no);

  Notification_ptr getChannel(size_t no) const;
  size_t getType(Notification_ptr channel) const;

protected:
  void removeChannel(size_t no);

private:
  //! grant Observable access to notifyAll() and subjectKilled()
  friend class Observable;
  //!> grant Relay access to notifyAll()
  friend class Relay;

  /** Informs channel subscribers about imminent dstor call.
   *
   * This is meant to be called from Observable only.
   * Channels and Notifications are strictly attached to an Observable. Hence,
   * it makes no sense to inform them on their own. Especially, neither has
   * any knowledge on the publisher.
   *
   * \param *publisher Observable about to be destroyed
   */
  void subjectKilled(Observable * const publisher);

private:
  typedef std::map< size_t, Notification_ptr> NotificationTypetoRefMap;

  NotificationTypetoRefMap ChannelMap;
};

#endif /* CHANNELS_HPP_ */
