/*
 * SumUpPerLevel.hpp
 *
 *  Created on: Aug 27, 2012
 *      Author: heber
 */

#ifndef SUMUPPERLEVEL_HPP_
#define SUMUPPERLEVEL_HPP_


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <map>
#include <vector>

#include "Fragmentation/Converter/DataConverter.hpp"
#include "Fragmentation/Summation/AllLevelSummator.hpp"
#include "Fragmentation/Summation/IndexSetContainer.hpp"

#include "Jobs/MPQCData.hpp"

#include <boost/mpl/for_each.hpp>

template <typename TypeMap, typename TypeVector>
std::vector<TypeMap> SumUpPerLevel(
    const std::map<JobId_t, MPQCData> &fragmentData,
    const std::map< JobId_t, size_t > &MatrixNrLookup,
    const IndexSetContainer::ptr &container,
    SubsetMap::ptr &subsetmap
    )
{
  // place data into boost::fusion::map instance
  std::map<JobId_t, TypeMap> MPQCData_fused;
  convertDataTo<MPQCData, TypeMap>(fragmentData, MPQCData_fused);
  // instantiate summator
  std::vector<TypeMap> Result_fused(subsetmap->getMaximumSubsetLevel());
  AllLevelSummator<TypeMap> Summer(
              subsetmap,
              MPQCData_fused,
              container->getContainer(),
              MatrixNrLookup,
              Result_fused);
  // sum up for each type key in TypeVector
  boost::mpl::for_each<TypeVector>(boost::ref(Summer));
  return Result_fused;
}


#endif /* SUMUPPERLEVEL_HPP_ */
