/*
 * Box.cpp
 *
 *  Created on: Jun 30, 2010
 *      Author: crueger
 */

#include "Helpers/MemDebug.hpp"

#include "Box.hpp"

#include "Matrix.hpp"
#include "vector.hpp"

#include "Helpers/Assert.hpp"

Box::Box()
{
  M= new Matrix();
  M->one();
  Minv = new Matrix();
  Minv->one();
}

Box::Box(const Box& src){
  M=new Matrix(*src.M);
  Minv = new Matrix(*src.Minv);
}

Box::~Box()
{
  delete M;
  delete Minv;
}

const Matrix &Box::getM() const{
  return *M;
}
const Matrix &Box::getMinv() const{
  return *Minv;
}

void Box::setM(Matrix _M){
  ASSERT(_M.at(1,0)==_M.at(0,1),"Matrix used as cell_size was not symmetric");
  ASSERT(_M.at(2,0)==_M.at(0,2),"Matrix used as cell_size was not symmetric");
  ASSERT(_M.at(1,2)==_M.at(2,1),"Matrix used as cell_size was not symmetric");
  *M    =_M;
  *Minv = M->invert();
}

Vector Box::translateIn(const Vector &point){
  return (*M) * point;
}

Vector Box::translateOut(const Vector &point){
  return (*Minv) * point;
}

Box &Box::operator=(const Box &src){
  if(&src!=this){
    delete M;
    delete Minv;
    M    = new Matrix(*src.M);
    Minv = new Matrix(*src.Minv);
  }
  return *this;
}

Box &Box::operator=(const Matrix &mat){
  setM(mat);
  return *this;
}
