/*
 * FragmentScheduler.hpp
 *
 *  Created on: Oct 19, 2011
 *      Author: heber
 */

#ifndef FRAGMENTSCHEDULER_HPP_
#define FRAGMENTSCHEDULER_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <vector>
#include <boost/asio.hpp>

#include "Connection.hpp"
#include "FragmentJob.hpp"
#include "FragmentQueue.hpp"
#include "FragmentResult.hpp"

/** FragmentScheduler serves FragmentJobs to Workers.
 *
 */
class FragmentScheduler
{
public:
  /// Constructor opens the acceptor and starts waiting for the first incoming
  /// Connection.
  FragmentScheduler(boost::asio::io_service& io_service, unsigned short workerport, unsigned short controllerport);

  enum Exitflag_t{
    OkFlag = 0,
    ControllerErrorFlag = 254,
    WorkerErrorFlag = 255
  };

  /** Getter for Exitflag.
   *
   * @return Exitflag of operations
   */
  size_t getExitflag() const
  {
    return Exitflag;
  }

protected:
  /// Handle completion of a accept worker operation.
  void handle_AcceptWorker(const boost::system::error_code& e, connection_ptr conn);

  /// Handle completion of a accept controller operation.
  void handle_AcceptController(const boost::system::error_code& e, connection_ptr conn);

  /// Worker callback function when job has been sent.
  void handle_SendJobtoWorker(const boost::system::error_code& e, connection_ptr conn);

  /// Worker callback function when result has been received.
  void handle_ReceiveResultFromWorker(const boost::system::error_code& e, connection_ptr conn);

  /// Controller callback function when job has been sent.
  void handle_ReceiveJobs(const boost::system::error_code& e, connection_ptr conn);

private:

  /// Controller callback function when checking on state of results.
  void handle_CheckResultState(const boost::system::error_code& e, connection_ptr conn);

  /// The acceptor object used to accept incoming worker socket connections.
  boost::asio::ip::tcp::acceptor worker_acceptor_;

  /// The acceptor object used to accept incoming controller socket connections.
  boost::asio::ip::tcp::acceptor controller_acceptor_;

  /// result that is received from the client.
  FragmentResult result;

  /// bunch of jobs received from controller before placed in JobsQueue
  std::vector<FragmentJob> jobs;

  /// number of jobs that are calculated, required for returning status
  size_t doneJobs;

  /// Queue with data to be sent to each client.
  FragmentQueue JobsQueue;

  // static entity to indicate to clients that the queue is empty.
  static FragmentJob NoJob;

  // Exit flag on program exit
  enum Exitflag_t Exitflag;
};

#endif /* FRAGMENTSCHEDULER_HPP_ */
