/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * CenterInBoxAction.cpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Box.hpp"
#include "CodePatterns/Log.hpp"
#include "LinearAlgebra/RealSpaceMatrix.hpp"
#include "molecule.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "Actions/WorldAction/CenterInBoxAction.hpp"

// and construct the stuff
#include "CenterInBoxAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr WorldCenterInBoxAction::performCall() {
  // obtain information
  getParametersfromValueStorage();

  World::getInstance().setDomain(params.cell_size.getM());

  // center
  vector<molecule *> AllMolecules = World::getInstance().getAllMolecules();
  for (vector<molecule*>::iterator MolRunner = AllMolecules.begin(); MolRunner != AllMolecules.end(); ++MolRunner) {
    (*MolRunner)->CenterInBox();
  }

  // give final box size
  LOG(0, "Box domain is now " << World::getInstance().getDomain().getM());

  return Action::success;
}

Action::state_ptr WorldCenterInBoxAction::performUndo(Action::state_ptr _state) {
//  ParserLoadXyzState *state = assert_cast<ParserLoadXyzState*>(_state.get());

  return Action::failure;
//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);
//
//  return Action::state_ptr(new ParserLoadXyzState(state->mol,newName));
}

Action::state_ptr WorldCenterInBoxAction::performRedo(Action::state_ptr _state){
  return Action::failure;
}

bool WorldCenterInBoxAction::canUndo() {
  return false;
}

bool WorldCenterInBoxAction::shouldUndo() {
  return false;
}
/** =========== end of function ====================== */
