/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * GLMoleculeObject_molecule.cpp
 *
 *  Created on: Mar 30, 2012
 *      Author: ankele
 */





// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "GLMoleculeObject_molecule.hpp"

#include <Qt3D/qglbuilder.h>
#include <Qt3D/qglscenenode.h>
#include <Qt3D/qglsphere.h>

#include "CodePatterns/MemDebug.hpp"

#include "CodePatterns/Assert.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Observer/Notification.hpp"

#include "Atom/atom.hpp"
#include "molecule.hpp"
#include "Descriptors/AtomIdDescriptor.hpp"
#include "Element/element.hpp"
#include "LinearAlgebra/Vector.hpp"
#include "World.hpp"

static QGLSceneNode * createMolecule(QObject *parent)
{
  // create an empty mesh...
  QGLBuilder builder;
  QGLSceneNode *n = builder.finalizedSceneNode();
  n->setParent(parent);
  return n;
}

GLMoleculeObject_molecule::GLMoleculeObject_molecule(QObject *parent, const molecule *molref) :
  GLMoleculeObject(createMolecule(parent), parent),
  Observer(std::string("GLMoleculeObject_molecule")+toString(molref->getId())),
  _molecule(molref)
{
  // sign on as observer (obtain non-const instance before)
  /*molref->signOn(this, AtomObservable::IndexChanged);
  molref->signOn(this, AtomObservable::PositionChanged);
  molref->signOn(this, AtomObservable::ElementChanged);
  molref->signOn(this, AtomObservable::BondsAdded);*/
  World::getInstance().signOn(this, World::SelectionChanged);
  setPosition(QVector3D(0,0,0));
  setScale(5.0f);
  setMaterial(getMaterial(1));
}

GLMoleculeObject_molecule::~GLMoleculeObject_molecule()
{
  /*_atom->signOff(this, AtomObservable::IndexChanged);
  _atom->signOff(this, AtomObservable::PositionChanged);
  _atom->signOff(this, AtomObservable::ElementChanged);
  _atom->signOff(this, AtomObservable::BondsAdded);*/
  World::getInstance().signOff(this, World::SelectionChanged);
}

void GLMoleculeObject_molecule::update(Observable *publisher)
{
#ifdef LOG_OBSERVER
  observerLog().addMessage() << "++ Update of Observer " << observerLog().getName(this) << " from atom "+toString(_atom->getId())+".";
#endif
}

void GLMoleculeObject_molecule::subjectKilled(Observable *publisher)
{}

void GLMoleculeObject_molecule::recieveNotification(Observable *publisher, Notification_ptr notification)
{
  if (publisher == dynamic_cast<const Observable*>(_molecule)){
    // notofication from atom
#ifdef LOG_OBSERVER
    observerLog().addMessage() << "++ Update of Observer "<< observerLog().getName(this)
          << " received notification from molecule " << _molecule->getId() << " for channel "
          << notification->getChannelNo() << ".";
#endif
  }else{
    // notification from world
#ifdef LOG_OBSERVER
    observerLog().addMessage() << "++ Update of Observer "<< observerLog().getName(this)
          << " received notification from world for channel "
          << notification->getChannelNo() << ".";
#endif
    switch (notification->getChannelNo()) {
      case World::SelectionChanged:
        setSelected(World::getInstance().isSelected(_molecule));
        break;
      default:
        break;
    }
  }
}

