/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * DiscreteParameterUnitTest.cpp
 *
 *  Created on: Sep 30, 2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "DiscreteParameterUnitTest.hpp"

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#include "Parser/Parameters/DiscreteParameter.hpp"

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

using namespace std;

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( DiscreteParameterTest );


void DiscreteParameterTest::setUp()
{
  // failing asserts should be thrown
  ASSERT_DO(Assert::Throw);

  for (int i=1; i<=3;++i) {
    ValidValues.push_back(i);
  }
}

void DiscreteParameterTest::tearDown()
{
  ValidValues.clear();
}

/************************************ tests ***********************************/

/** Unit test for clone.
 *
 */
void DiscreteParameterTest::cloneTest()
{
  // create instance
  DiscreteParameter<int> test("intParam", ValidValues);

  // check that we throw because of unset parameter
#ifndef NDEBUG
  std::cout << "The following Assert failures are intended and do not indicate a failure of the test." << std::endl;
  CPPUNIT_ASSERT_THROW(test.clone(), Assert::AssertionFailure);
#endif

  // set parameter
  test.setValue(2);

  // is returned as Parameter but we can compare only in true class as
  // Parameter may also be a ContinuousParameter where comparison is nonsense
  DiscreteParameter<int> *instance = dynamic_cast< DiscreteParameter<int> *> (test.clone());

  // different places in memory
  CPPUNIT_ASSERT( &test != instance);

  // but same contents
  CPPUNIT_ASSERT( test == *instance);
}

