/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * ContinuousParameterUnitTest.cpp
 *
 *  Created on: Sep 30, 2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "ContinuousParameterUnitTest.hpp"

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#include "Parser/Parameters/ContinuousParameter.hpp"

#include "CodePatterns/Range.hpp"

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( ContinuousParameterTest );


void ContinuousParameterTest::setUp()
{
  // failing asserts should be thrown
  ASSERT_DO(Assert::Throw);

  ValidRange = new range<int>(1,4);
}

void ContinuousParameterTest::tearDown()
{
  delete ValidRange;
}

/************************************ tests ***********************************/

/** Unit test for clone.
 *
 */
void ContinuousParameterTest::cloneTest()
{
  // create instance
  ContinuousParameter<int> test("intParam", *ValidRange);

  // check that we throw because of unset parameter
#ifndef NDEBUG
  std::cout << "The following Assert failures are intended and do not indicate a failure of the test." << std::endl;
  CPPUNIT_ASSERT_THROW(test.clone(), Assert::AssertionFailure);
#endif

  // set parameter
  test.setValue(2);

  // is returned as Parameter but we can compare only in true class as
  // Parameter may also be a DiscreteParameter where comparison is nonsense
  ContinuousParameter<int> *instance = dynamic_cast< ContinuousParameter<int> *> (test.clone());

  // different places in memory
  CPPUNIT_ASSERT( &test != instance);

  // but same contents
  CPPUNIT_ASSERT( test == *instance);
}

