/*
 * DiscreteParameter_impl.hpp
 *
 *  Created on: Sep 30, 2011
 *      Author: heber
 */

#ifndef DISCRETEPARAMETER_IMPL_HPP_
#define DISCRETEPARAMETER_IMPL_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "DiscreteParameter.hpp"

#include <vector>

/** Constructor for class DiscreteParameter.
 *
 */
template<typename T>
DiscreteParameter<T>::DiscreteParameter(const std::string &_name) :
  Parameter(_name)
{};

/** Constructor for class DiscreteParameter.
 *
 * @param _name name of this parameter
 * @param _ValidValues valid values for this DiscreteValue
 */
template<typename T>
DiscreteParameter<T>::DiscreteParameter(const std::string &_name, const std::vector<T> &_ValidValues) :
  Parameter(_name),
  DiscreteValue<T>(_ValidValues)
{};

/** Destructor for class DiscreteParameter.
 *
 */
template<typename T>
DiscreteParameter<T>::~DiscreteParameter()
{};

/** Creates a clone of this Parameter instance.
 *
 * @return cloned instance
 */
template<typename T>
Parameter* DiscreteParameter<T>::clone() const
{
  DiscreteParameter<T> *instance = new DiscreteParameter<T>(Parameter::getName(), DiscreteValue<T>::getValidValues());
  instance->setValue(DiscreteValue<T>::getValue());
  return instance;
}


#endif /* DISCRETEPARAMETER_IMPL_HPP_ */
