/*
 * DiscreteParameter.hpp
 *
 *  Created on: Sep 30, 2011
 *      Author: heber
 */

#ifndef DISCRETEPARAMETER_HPP_
#define DISCRETEPARAMETER_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string>

#include "DiscreteValue.hpp"
#include "Parameter.hpp"

#include <vector>

/** This class encapsulates a clonable, continuous value.
 *
 */
template <typename T>
class DiscreteParameter : public Parameter, public DiscreteValue<T>
{
public:
  DiscreteParameter(const std::string &_name);
  DiscreteParameter(const std::string &_name, const std::vector<T> &_ValidValues);
  virtual ~DiscreteParameter();

  Parameter* clone() const;

private:
  DiscreteParameter();
};

#include "DiscreteParameter_impl.hpp"

#endif /* DISCRETEPARAMETER_HPP_ */
