/*
 * CommandLineQuery.hpp
 *
 *  Created on: Nov 8, 2010
 *      Author: heber
 */

#ifndef COMMANDLINEQUERY_HPP_
#define COMMANDLINEQUERY_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include "CommandLineUI/CommandLineDialog.hpp"

class CommandLineDialog::EmptyCommandLineQuery : public Dialog::EmptyQuery {
public:
  EmptyCommandLineQuery(const std::string &_title, const std::string &_description = "");
  virtual ~EmptyCommandLineQuery();
  virtual bool handle();
};

  /** With the following boost::preprocessor code we generate forward declarations
   * of query class for all desired query types in the Qt specialization class of
   * Dialog.
   */
#include "UIElements/GlobalListOfParameterQueries.hpp"
#include "UIElements/Dialog_impl_pre.hpp"

  #include <boost/preprocessor/facilities/empty.hpp>

  // iterate over all parameter query types for forward declarations
  #if defined GLOBALLISTOFPARAMETERQUERIES_Token && defined GLOBALLISTOFPARAMETERQUERIES_Type
  #define BOOST_PP_LOCAL_MACRO(n) queryclass_definition(~, n, GLOBALLISTOFPARAMETERQUERIES_Token, GLOBALLISTOFPARAMETERQUERIES_Type, CommandLine)
  #define BOOST_PP_LOCAL_LIMITS  (0, MAXPARAMETERTOKENS-1)
  #include BOOST_PP_LOCAL_ITERATE()
  #undef queryclass_definition
  #endif

#include "Dialog_impl_undef.hpp"
  /* End of preprocessor code piece */


#endif /* COMMANDLINEQUERY_HPP_ */
