/*
 * GLMoleculeObject_bond.hpp
 *
 *  Created on: Aug 17, 2011
 *      Author: heber
 */

#ifndef GLMOLECULEOBJECT_BOND_HPP_
#define GLMOLECULEOBJECT_BOND_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "GLMoleculeObject.hpp"

#include "CodePatterns/Observer/Observer.hpp"

#include "Bond/bond.hpp"
#include "types.hpp"

class atom;

class GLMoleculeObject_bond : public GLMoleculeObject, public Observer
{
  Q_OBJECT
public:
  enum SideOfBond { left, right };

  GLMoleculeObject_bond(QGLSceneNode *mesh[], QObject *parent, const bond::ptr bondref, const enum SideOfBond side);
  virtual ~GLMoleculeObject_bond();

  // Observer functions
  void update(Observable *publisher);
  void subjectKilled(Observable *publisher);
  void recieveNotification(Observable *publisher, Notification_ptr notification);

signals:
  void BondRemoved(const atomId_t leftnr, const atomId_t rightnr);

private:
  /** Recalculates the position of the cylinder representing the bond.
   *
   */
  void resetPosition();

  /** Recalculates the width of the cylinder representing the bond's degree.
   *
   */
  void resetWidth();

  const bond& _bond;
  /** Observable instance inside atom_observable for left bond partner.
   * We require this knowledge as subjectKilled is called by Observable, not
   * by AtomObservable which has already been destroyed at this time.
   *
   */
  const Observable *leftatom;
  /** Observable instance inside atom_observable for right bond partner.
   * We require this knowledge as subjectKilled is called by Observable, not
   * by AtomObservable which has already been destroyed at this time.
   *
   */
  const Observable *rightatom;
  //!> id of left bond partner for safely emitting BondRemoved sigbal
  const atomId_t leftatomId;
  //!> id of right bond partner for safely emitting BondRemoved sigbal
  const atomId_t rightatomId;
  const enum SideOfBond BondSide;
};



#endif /* GLMOLECULEOBJECT_BOND_HPP_ */
