/*
 * FragmentationResults.hpp
 *
 *  Created on: Aug 31, 2012
 *      Author: heber
 */

#ifndef FRAGMENTATIONRESULTS_HPP_
#define FRAGMENTATIONRESULTS_HPP_


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <map>
#include <string>
#include <vector>

#include "JobMarket/types.hpp"

#include "Jobs/MPQCData.hpp"
#include "Jobs/MPQCDataMap.hpp"
#include "Jobs/VMGData.hpp"
#include "Jobs/VMGDataMap.hpp"
#include "Jobs/Grid/SamplingGrid.hpp"

/** FragmentationResults contains the summed up results per level resulting
 * from the fragmentation of the molecular system and clever combination of
 * fragmentary energies, forces, timings, and so on.
 *
 * This structure is mostly a storage wherein the summed up results are
 * contained for subsequent pretty printing and so on.
 *
 */
struct FragmentationResults
{
  /** Constructor for class FragmentationResults.
   *
   * Performs the summation and fills all result vectors.
   *
   * @param fragmentData results from short-range fragment calculations
   * @param longrangeData results from long-range fragment calculations
   * @param fullsolutionData results from long-range full calculations
   * @param KeySetFilename path to fragment files
   * @param NoAtoms number of atoms of full system
   * @param full_sample summed up grid charge
   */
  FragmentationResults(
      const std::map<JobId_t,MPQCData> &fragmentData,
      const std::map<JobId_t,VMGData> &longrangeData,
      const std::vector<VMGData> &fullsolutionData,
      const std::string &KeySetFilename,
      const size_t NoAtoms,
      const std::vector<SamplingGrid> &full_sample);

  size_t getMaxLevel() const {
    return MaxLevel;
  }

  //!> results per level of summed up energy
  std::vector<MPQCDataEnergyMap_t> Result_Energy_fused;
  //!> results per level of summed up sampled grid charge
  std::vector<MPQCDataGridMap_t> Result_Grid_fused;
  //!> results per level of summed up times
  std::vector<MPQCDataTimeMap_t> Result_Time_fused;
  //!> results per level of summed up fragment positions and charges
  std::vector<MPQCDataFragmentMap_t> Result_Fragment_fused;
  //!> results per level of summed up forces
  std::vector<MPQCDataForceMap_t> Result_Force_fused;
  //!> results per level of summed up long range potential grids and energy
  std::vector<VMGDataMap_t> Result_LongRange_fused;
  //!> results per level of summed up long range true energy
  std::vector<VMGDataLongRangeMap_t> Result_LongRangeIntegrated_fused;

private:
  //!> maximum level of summation
  size_t MaxLevel;
};


#endif /* FRAGMENTATIONRESULTS_HPP_ */
