/*
 * CommandLineUIFactory.hpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

#ifndef COMMANDLINEUIFACTORY_HPP_
#define COMMANDLINEUIFACTORY_HPP_

#include "UIFactory.hpp"

/** This class is a specialization of the UIFactory.
 *
 * <h2> Introduction </h2>
 *
 * The UIFactory is a base class for the User Interaction. There are three UI specializations:
 * Text, GUI and CommandLine.
 *
 * The idea of the command line part is as follows:
 *
 * All actions that can be called from the command line are instantiated via populater-functions.
 * In the constructor of an action it is automatically registered with the ActionRegistry and can
 * henceforth be looked up there.
 *
 * There is a CommandLineParser which parses the command line parameters and puts all found values
 * into a map. Then, MainWindow::Display of the CommandLineUIFactory is called, which goes through
 * every action (by the ActionRegistry) and looks through the parsed commands whether the action is
 * desired.
 *
 * In the action itself, Query's ask for user input. In the CommandLine case, we don't want direct
 * user interaction, but the user has to have those values already delivered along with the desired
 * action. Hence, the Query implementations just look up the desired values in the CommandLineParser
 * vaults. When they are not found, an exception is thrown. When all are found, the action is performed.
 *
 */
class CommandLineUIFactory : public UIFactory
{
friend class UIFactory;

public:
  virtual ~CommandLineUIFactory();

  virtual Dialog* makeDialog();
  virtual MainWindow* makeMainWindow();

  struct description : public UIFactory::factoryDescription {
    description();
    virtual ~description();

    virtual UIFactory* makeFactory();
  };

protected:
  CommandLineUIFactory();
};


#endif /* COMMANDLINEUIFACTORY_HPP_ */
