/*
 * TranslateAction.cpp
 *
 *  Created on: May 10, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/AtomAction/TranslateAction.hpp"
#include "Actions/ActionRegistry.hpp"
#include "Helpers/Log.hpp"
#include "atom.hpp"
#include "LinearAlgebra/Vector.hpp"
#include "Helpers/Verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <fstream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/ValueStorage.hpp"

/****** AtomTranslateAction *****/

// memento to remember the state when undoing

class AtomTranslateState : public ActionState {
public:
  AtomTranslateState(std::vector<atom*> _selectedAtoms, Vector &_v) :
    selectedAtoms(_selectedAtoms),
    v(_v)
  {}
  std::vector<atom*> selectedAtoms;
  Vector v;
};

const char AtomTranslateAction::NAME[] = "translate-atoms";

AtomTranslateAction::AtomTranslateAction() :
  Action(NAME)
{}

AtomTranslateAction::~AtomTranslateAction()
{}

void AtomTranslate(Vector &x) {
  ValueStorage::getInstance().setCurrentValue(AtomTranslateAction::NAME, x);
  ActionRegistry::getInstance().getActionByName(AtomTranslateAction::NAME)->call(Action::NonInteractive);
};

Dialog* AtomTranslateAction::fillDialog(Dialog *dialog) {
  ASSERT(dialog,"No Dialog given when filling action dialog");

  dialog->queryVector(NAME, false, ValueStorage::getInstance().getDescription(NAME));

  return dialog;
}

Action::state_ptr AtomTranslateAction::performCall() {
  Vector v;
  std::vector<atom *> selectedAtoms = World::getInstance().getSelectedAtoms();

  ValueStorage::getInstance().queryCurrentValue(NAME, v);

  // TODO: use AtomSet::translate
  for (std::vector<atom *>::iterator iter = selectedAtoms.begin(); iter != selectedAtoms.end(); ++iter) {
    *(*iter) += v;
  }
  return Action::state_ptr(new AtomTranslateState(selectedAtoms, v));
}

Action::state_ptr AtomTranslateAction::performUndo(Action::state_ptr _state) {
  AtomTranslateState *state = assert_cast<AtomTranslateState*>(_state.get());

  for (std::vector<atom *>::iterator iter = state->selectedAtoms.begin(); iter != state->selectedAtoms.end(); ++iter) {
    *(*iter) -= state->v;
  }

  return Action::state_ptr(new AtomTranslateState(state->selectedAtoms, state->v));
}

Action::state_ptr AtomTranslateAction::performRedo(Action::state_ptr _state){
  AtomTranslateState *state = assert_cast<AtomTranslateState*>(_state.get());

  for (std::vector<atom *>::iterator iter = state->selectedAtoms.begin(); iter != state->selectedAtoms.end(); ++iter) {
    *(*iter) += state->v;
  }

  return Action::state_ptr(new AtomTranslateState(state->selectedAtoms, state->v));
}

bool AtomTranslateAction::canUndo() {
  return true;
}

bool AtomTranslateAction::shouldUndo() {
  return true;
}

const string AtomTranslateAction::getName() {
  return NAME;
}
