/*
 * QSeisXMLParser_plottype.hpp
 *
 *  Created on: Apr 5, 2011
 *      Author: bierbach
 */

#ifndef QSEISXMLPARSER_PLOTTYPE_HPP_
#define QSEISXMLPARSER_PLOTTYPE_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string>
#include <vector>
#include <map>
#include <sstream>


class plottype{
	public:
  enum axis
  {
    X,
    Y
  };

  plottype(std::string name_pt,std::string xlabel_pt,std::string ylabel_pt,std::string style_pt,const std::vector<int> &xunits_pt,const std::vector<int> &yunits_pt, const std::vector<std::string> &unitnames_pt,const std::map<std::string,std::string> &unitmap_pt);
  ~plottype();

	void set_values(std::string,std::string,std::string,std::string,const std::vector<int>&,const std::vector<int>&,const std::vector<std::string>&,const std::map<std::string,std::string>&);
	bool operator==(std::string);
	std::string get_name() const;
	std::string get_label(const enum axis _axis) const;
	std::string get_style() const;
	std::string get_units(const enum axis _axis) const;

	private:
  typedef std::vector<int> UnitsVector;
	typedef std::map<enum axis, std::string > LabelPerAxis;
	typedef std::map<enum axis, UnitsVector > UnitPerAxis;
	typedef std::map<std::string,std::string> UnitNamesMap;
	typedef std::vector<std::string> UnitNamesVector;

	std::string name,style;
	UnitPerAxis units;
	LabelPerAxis labels;
	UnitNamesVector unitnames;
	UnitNamesMap unitmap;

	private:
	plottype(const plottype& ref);
};

#endif /* QSEISXMLPARSER_PLOTTYPE_HPP_ */
