/*
 * QSeisXMLParser_plotcurve.cpp
 *
 *  Created on: Apr 5, 2011
 *      Author: bierbach
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// have this after(!) all Qt includes
#include "CodePatterns/MemDebug.hpp"

#include <iostream>
#include "QSeisXMLParser_plotcurve.hpp"

plotcurve::plotcurve(std::string name_pc,std::string type_pc,std::string suffix_pc,std::string color_pc,int column_pc) :
	name(name_pc),type(type_pc),suffix(suffix_pc),color(color_pc),column(column_pc)
	{}

/** Explicit copy constructor for class plotcurve.
 *
 * \note is made private to prevent accidental copying of the instance.
 *
 * @param ref instance to copy
 */
plotcurve::plotcurve(const plotcurve &ref) :
	name(ref.name),type(ref.type),suffix(ref.suffix),color(ref.color),column(ref.column)
{
  std::cout << "plotcurve " << &ref << " has been copied." << std::endl;
	std::cout << ref.name << " --- " << ref.type << " --- " << ref.suffix << std::flush;
	std::cout << " --- " << ref.color << " --- " << ref.column <<  std::endl;
}

plotcurve::~plotcurve()
{}

void plotcurve::set_values(std::string name_pc,std::string type_pc,std::string suffix_pc,int column_pc) {
	name=name_pc;type=type_pc;suffix=suffix_pc;column=column_pc;
}

std::string plotcurve::get_name() {
	return name;
}

std::string plotcurve::get_type() {
	return type;
}

std::string plotcurve::get_suffix() {
	return suffix;
}

std::string plotcurve::get_color() {
	return color;
}

int plotcurve::get_column() {
	return column;
}
