/*
 * QSeisXMLParser.hpp
 *
 *  Created on: Apr 5, 2011
 *      Author: bierbach
 */

#ifndef QSEISXMLPARSER_HPP_
#define QSEISXMLPARSER_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <QtCore/QStringList>
#include <QtCore/QString>
#include <QtCore/QFileInfo>

#include "UIElements/Views/Qt4/Plotting/XMLParser/QSeisXMLParser_plottype.hpp"
#include "UIElements/Views/Qt4/Plotting/XMLParser/QSeisXMLParser_plotcurve.hpp"

#include <vector>
#include <map>
#include <iosfwd>
#include <utility>

#include "CodePatterns/Singleton.hpp"

class QSeisXMLParser : public Singleton<QSeisXMLParser> {
	friend class Singleton<QSeisXMLParser>;
	friend class plotcurve;
	friend class XMLParserTest;

	public:
	QStringList getFiles(QString);
	void load(std::istream&);
	void createPlotPages();
	void associateCurves();
	QString getTypeOfName(const QString &name);
	std::string getCurveColor(std::string);
	plottype* return_plottype_by_name(std::string name);
	void set_units(const std::vector<std::string>&,const std::map<std::string,std::string>&);

	protected:
	QSeisXMLParser();
	~QSeisXMLParser();

	private:
	QString prefix;
	std::map<std::string, std::string> unitmap;
	std::vector<std::string> unitnames;
	std::vector<plottype*> types;
	std::map<std::string,plottype*> types_by_name;
	std::vector<plotcurve*> curves;
	std::map<std::string,plotcurve*> curves_suff;
	std::map<std::string,std::string> curves_by_suffix;
};

#endif /* QSEISXMLPARSER_HPP_ */
