/*
 * analysisbondsunittest.hpp
 *
 *  Created on: Nov 7, 2009
 *      Author: heber
 */

#ifndef ANALYSISBONDSUNITTEST_HPP_
#define ANALYSISBONDSUNITTEST_HPP_

#include <cppunit/extensions/HelperMacros.h>

#include "bondgraph.hpp"

class element;
class molecule;
class periodentafel;

/********************************************** Test classes **************************************/

class AnalysisBondsTest : public CppUnit::TestFixture
{
    CPPUNIT_TEST_SUITE( AnalysisBondsTest) ;
    CPPUNIT_TEST ( BondsTest );
    CPPUNIT_TEST_SUITE_END();

public:
      void setUp();
      void tearDown();
      void BondsTest();

private:

      molecule *TestMolecule;
      element *hydrogen;
      element *carbon;
      periodentafel *tafel;

      BondGraph *BG;
      string *filename;
};

#endif /* ANALYSISBONDSUNITTEST_HPP_ */
