/*
 * analysisbondsunittest.cpp
 *
 *  Created on: Nov 7, 2009
 *      Author: heber
 */

using namespace std;

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#include <iostream>
#include <stdio.h>

#include "atom.hpp"
#include "bond.hpp"
#include "bondgraph.hpp"
#include "element.hpp"
#include "molecule.hpp"
#include "periodentafel.hpp"
#include "analysisbondsunittest.hpp"

/********************************************** Test classes **************************************/

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( AnalysisBondsTest );


void AnalysisBondsTest::setUp()
{
  atom *Walker = NULL;

  // init private all pointers to zero
  TestMolecule = NULL;
  hydrogen = NULL;
  tafel = NULL;

  // construct element
  hydrogen = new element;
  hydrogen->Z = 1;
  strcpy(hydrogen->name, "hydrogen");
  strcpy(hydrogen->symbol, "H");
  carbon = new element;
  carbon->Z = 1;
  strcpy(carbon->name, "carbon");
  strcpy(carbon->symbol, "C");


  // construct periodentafel
  tafel = new periodentafel;
  tafel->AddElement(hydrogen);
  tafel->AddElement(carbon);

  // construct molecule (tetraeder of hydrogens)
  TestMolecule = new molecule(tafel);
  Walker = new atom();
  Walker->type = hydrogen;
  Walker->node->Init(1., 0., 1. );
  TestMolecule->AddAtom(Walker);
  Walker = new atom();
  Walker->type = hydrogen;
  Walker->node->Init(0., 1., 1. );
  TestMolecule->AddAtom(Walker);
  Walker = new atom();
  Walker->type = hydrogen;
  Walker->node->Init(1., 1., 0. );
  TestMolecule->AddAtom(Walker);
  Walker = new atom();
  Walker->type = hydrogen;
  Walker->node->Init(0., 0., 0. );
  TestMolecule->AddAtom(Walker);

  // check that TestMolecule was correctly constructed
  CPPUNIT_ASSERT_EQUAL( TestMolecule->AtomCount, 4 );

  // create a small file with table
  filename = new string("test.dat");
  ofstream test(filename->c_str());
  test << ".\tH\tC\n";
  test << "H\t1.\t1.2\n";
  test << "C\t1.2\t1.5\n";
  BG = new BondGraph(true);
};


void AnalysisBondsTest::tearDown()
{
  // remove the file
  remove(filename->c_str());
  delete(filename);
  delete(BG);

  // remove molecule
  delete(TestMolecule);
  // note that all the atoms are cleaned by TestMolecule
  delete(tafel);
  // note that element is cleaned by periodentafel
};

/** UnitTest for AnalysisBondsTest::LoadBondLengthTable().
 */
void AnalysisBondsTest::BondsTest()
{
  CPPUNIT_ASSERT_EQUAL( true , BG->LoadBondLengthTable(*filename) );
  CPPUNIT_ASSERT_EQUAL( 1., BG->GetBondLength(0,0) );
  CPPUNIT_ASSERT_EQUAL( 1.2, BG->GetBondLength(0,1) );
  CPPUNIT_ASSERT_EQUAL( 1.5, BG->GetBondLength(1,1) );

  CPPUNIT_ASSERT_EQUAL( true , true );

};

/********************************************** Main routine **************************************/

int main(int argc, char **argv)
{
  // Get the top level suite from the registry
  CppUnit::Test *suite = CppUnit::TestFactoryRegistry::getRegistry().makeTest();

  // Adds the test to the list of test to run
  CppUnit::TextUi::TestRunner runner;
  runner.addTest( suite );

  // Change the default outputter to a compiler error format outputter
  runner.setOutputter( new CppUnit::CompilerOutputter( &runner.result(),
                                                       std::cerr ) );
  // Run the tests.
  bool wasSucessful = runner.run();

  // Return error code 1 if the one of test failed.
  return wasSucessful ? 0 : 1;
};
