/*
 * TextQuery.hpp
 *
 *  Created on: Nov 8, 2010
 *      Author: heber
 */

#ifndef TEXTQUERY_HPP_
#define TEXTQUERY_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include "TextUI/TextDialog.hpp"

class TextDialog::AtomTextQuery : public Dialog::TQuery<const atom *> {
public:
  AtomTextQuery(Parameter<const atom *> &, const std::string &_title, const std::string &_description = NULL);
  virtual ~AtomTextQuery();
  virtual bool handle();
};

class TextDialog::AtomsTextQuery : public Dialog::TQuery<std::vector<const atom *> > {
public:
  AtomsTextQuery(Parameter<std::vector<const atom *> > &, const std::string &_title, const std::string &_description = NULL);
  virtual ~AtomsTextQuery();
  virtual bool handle();
};

class TextDialog::BooleanTextQuery : public Dialog::TQuery<bool> {
public:
  BooleanTextQuery(Parameter<bool> &, const std::string &_title, const std::string &_description = NULL);
  virtual ~BooleanTextQuery();
  virtual bool handle();
};

class TextDialog::RealSpaceMatrixTextQuery : public Dialog::TQuery<RealSpaceMatrix> {
public:
  RealSpaceMatrixTextQuery(Parameter<RealSpaceMatrix> &, const std::string &_title, const std::string &_description = NULL);
  virtual ~RealSpaceMatrixTextQuery();
  virtual bool handle();
};

class TextDialog::DoubleTextQuery : public Dialog::TQuery<double> {
public:
  DoubleTextQuery(Parameter<double> &, const std::string &_title, const std::string &_description = NULL);
  virtual ~DoubleTextQuery();
  virtual bool handle();
};

class TextDialog::DoublesTextQuery : public Dialog::TQuery<std::vector<double> > {
public:
  DoublesTextQuery(Parameter<std::vector<double> > &, const std::string &_title, const std::string &_description = NULL);
  virtual ~DoublesTextQuery();
  virtual bool handle();
};

class TextDialog::ElementTextQuery : public Dialog::TQuery<const element *> {
public:
  ElementTextQuery(Parameter<const element *> &, const std::string &_title, const std::string &_description = NULL);
  virtual ~ElementTextQuery();
  virtual bool handle();
};

class TextDialog::ElementsTextQuery : public Dialog::TQuery<std::vector<const element *> > {
public:
  ElementsTextQuery(Parameter<std::vector<const element *> > &, const std::string &_title, const std::string &_description = NULL);
  virtual ~ElementsTextQuery();
  virtual bool handle();
};

class TextDialog::EmptyTextQuery : public Dialog::EmptyQuery {
public:
  EmptyTextQuery(const std::string &_title, const std::string &_description = NULL);
  virtual ~EmptyTextQuery();
  virtual bool handle();
};

class TextDialog::FileTextQuery : public Dialog::TQuery<boost::filesystem::path> {
public:
  FileTextQuery(Parameter<boost::filesystem::path> &, const std::string &_title, const std::string &_description = NULL);
  virtual ~FileTextQuery();
  virtual bool handle();
};

class TextDialog::FilesTextQuery : public Dialog::TQuery<std::vector<boost::filesystem::path> > {
public:
  FilesTextQuery(Parameter<std::vector< boost::filesystem::path> > &param, const std::string &_title, const std::string &_description = NULL);
  virtual ~FilesTextQuery();
  virtual bool handle();
};

class TextDialog::IntTextQuery : public Dialog::TQuery<int> {
public:
  IntTextQuery(Parameter<int> &, const std::string &_title, const std::string &_description = NULL);
  virtual ~IntTextQuery();
  virtual bool handle();
};

class TextDialog::IntsTextQuery : public Dialog::TQuery<std::vector<int> > {
public:
  IntsTextQuery(Parameter<std::vector<int> > &, const std::string &_title, const std::string &_description = NULL);
  virtual ~IntsTextQuery();
  virtual bool handle();
};

class TextDialog::KeyValuePairTextQuery : public Dialog::TQuery<KeyValuePair> {
public:
  KeyValuePairTextQuery(Parameter<KeyValuePair> &, const std::string &_title, const std::string &_description = NULL);
  virtual ~KeyValuePairTextQuery();
  virtual bool handle();
};

class TextDialog::KeyValuePairsTextQuery : public Dialog::TQuery<std::vector<KeyValuePair> > {
public:
  KeyValuePairsTextQuery(Parameter<std::vector<KeyValuePair> > &, const std::string &_title, const std::string &_description = NULL);
  virtual ~KeyValuePairsTextQuery();
  virtual bool handle();
};

class TextDialog::MoleculeTextQuery : public Dialog::TQuery<const molecule *> {
public:
  MoleculeTextQuery(Parameter<const molecule *> &, const std::string &_title, const std::string &_description = NULL);
  virtual ~MoleculeTextQuery();
  virtual bool handle();
};

class TextDialog::MoleculesTextQuery : public Dialog::TQuery<std::vector<const molecule *> > {
public:
  MoleculesTextQuery(Parameter<std::vector<const molecule *> > &, const std::string &_title, const std::string &_description = NULL);
  virtual ~MoleculesTextQuery();
  virtual bool handle();
};

class TextDialog::StringTextQuery : public Dialog::TQuery<std::string> {
public:
  StringTextQuery(Parameter<std::string> &, const std::string &_title, const std::string &_description = NULL);
  virtual ~StringTextQuery();
  virtual bool handle();
};

class TextDialog::StringsTextQuery : public Dialog::TQuery<std::vector<std::string> > {
public:
  StringsTextQuery(Parameter<std::vector<std::string> > &, const std::string &_title, const std::string &_description = NULL);
  virtual ~StringsTextQuery();
  virtual bool handle();
};

class TextDialog::UnsignedIntTextQuery : public Dialog::TQuery<unsigned int> {
public:
  UnsignedIntTextQuery(Parameter<unsigned int> &, const std::string &_title, const std::string &_description = NULL);
  virtual ~UnsignedIntTextQuery();
  virtual bool handle();
};

class TextDialog::UnsignedIntsTextQuery : public Dialog::TQuery<std::vector<unsigned int> > {
public:
  UnsignedIntsTextQuery(Parameter<std::vector<unsigned int> > &, const std::string &_title, const std::string &_description = NULL);
  virtual ~UnsignedIntsTextQuery();
  virtual bool handle();
};

class TextDialog::VectorTextQuery : public Dialog::TQuery<Vector> {
public:
  VectorTextQuery(Parameter<Vector> &, const std::string &_title, const std::string &_description = NULL);
  virtual ~VectorTextQuery();
  virtual bool handle();
};

class TextDialog::VectorsTextQuery : public Dialog::TQuery<std::vector<Vector> > {
public:
  VectorsTextQuery(Parameter<std::vector<Vector> > &, const std::string &_title, const std::string &_description = NULL);
  virtual ~VectorsTextQuery();
  virtual bool handle();
};

#endif /* TEXTQUERY_HPP_ */
