/*
 * QTMainWindow.cpp
 *
 *  Created on: Jan 14, 2010
 *      Author: crueger
 */

#include "QTMainWindow.hpp"

#include<Qt/qapplication.h>
#include<Qt/qlabel.h>
#include<Qt/qstring.h>
#include<Qt/qmenubar.h>
#include<Qt/qsplitter.h>

#include<iostream>
#include<boost/bind.hpp>

#include "atom.hpp"
#include "molecule.hpp"
#include "Menu/QT4/QTMenu.hpp"
#include "Views/QT4/QTMoleculesView.hpp"
#include "Views/QT4/GLMoleculeView.hpp"
#include "Views/QT4/QTStatusBar.hpp"


using namespace std;

QTMainWindow::QTMainWindow(menuPopulaters populaters,MoleculeListClass *molecules, config *configuration, periodentafel *periode, char *ConfigFileName,QApplication *_theApp) :
    theApp(_theApp)
{
  QSplitter *splitter1 = new QSplitter (Qt::Horizontal, this );
  QSplitter *splitter2 = new QSplitter (Qt::Vertical, splitter1 );

  moleculeDisplay = new QTMoleculesView(molecules,splitter2);

  QLabel *pseudo1 = new QLabel(QString("Here be dragons"));
  molecule3dDisplay = new GLMoleculeView();

  setCentralWidget(splitter1);
  splitter1->addWidget(splitter2);
  splitter1->addWidget(pseudo1);
  splitter2->addWidget(molecule3dDisplay);
  splitter2->addWidget(moleculeDisplay);

  statusBar = new QTStatusBar(this);
  setStatusBar(statusBar);

  editMoleculesMenu = new QTMenu("Edit Molecules");
  populaters.MakeEditMoleculesMenu(editMoleculesMenu,molecules,configuration,periode);
  menuBar()->addMenu(editMoleculesMenu);
}

QTMainWindow::~QTMainWindow()
{
  // TODO Auto-generated destructor stub
}

void QTMainWindow::display() {
  this->show();
  theApp->exec();
}
