/*
 * FragmentJob.hpp
 *
 *  Created on: Oct 19, 2011
 *      Author: heber
 */

#ifndef FRAGMENTJOB_HPP_
#define FRAGMENTJOB_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string>

#include "boost/serialization/access.hpp"

class StockClient;

/** FragmentJob contains all information for the Worker to start the job and
 * deliver a FragmentResult.
 *
 * Important is that this class is fully serializable such that it can be
 * transfered to a scheduler (server) and be deserialized by the Worker.
 */
class FragmentJob
{
  friend class StockClient;
public:
  FragmentJob();
  FragmentJob(const std::string &_outputfile, const int _JobId);
  ~FragmentJob();

  bool operator==(const FragmentJob &other) const;

  bool operator!=(const FragmentJob &other) const {
    return !(*this == other);
  }

private:
  friend class boost::serialization::access;
  // serialization
  template <typename Archive>
  void serialize(Archive& ar, const unsigned int version)
  {
    ar & outputfile;
    ar & JobId;
  }

private:
  //!> string containing the configuration file for the solver
  std::string outputfile;
  //!> unique id of this job (used for the temporary filename) and associating result
  int JobId;
};


#endif /* FRAGMENTJOB_HPP_ */
