/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * FragmentJob.cpp
 *
 *  Created on: Oct 19, 2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "FragmentJob.hpp"

/** Constructor for class FragmentJob.
 *
 */
FragmentJob::FragmentJob() :
  outputfile(""),
  JobId(-1)
{}

/** Constructor for class FragmentJob.
 *
 * \param _outputfile configuration file for solver
 * \param _JobId unique id of this job
 */
FragmentJob::FragmentJob(const std::string &_outputfile, const int _JobId) :
  outputfile(_outputfile),
  JobId(_JobId)
{}

/** Destructor for class FragmentJob.
 *
 */
FragmentJob::~FragmentJob()
{}

/** Comparator for class FragmentJob.
 * \param other instance to compare to
 * \return every member variable is the same, else - is not
 */
bool FragmentJob::operator==(const FragmentJob &other) const
{
  return (outputfile == other.outputfile) && (JobId == JobId);
}
