/*
 * AddEmptyBoundaryAction.cpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/WorldAction/AddEmptyBoundaryAction.hpp"
#include "Actions/ActionRegistry.hpp"
#include "atom.hpp"
#include "Helpers/Log.hpp"
#include "LinearAlgebra/Vector.hpp"
#include "World.hpp"

#include <iostream>
#include <string>
#include <vector>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/ValueStorage.hpp"
#include "Helpers/Assert.hpp"

const char WorldAddEmptyBoundaryAction::NAME[] = "boundary";

WorldAddEmptyBoundaryAction::WorldAddEmptyBoundaryAction() :
  Action(NAME)
{}

WorldAddEmptyBoundaryAction::~WorldAddEmptyBoundaryAction()
{}

void WorldAddEmptyBoundary(Vector &boundary) {
  ValueStorage::getInstance().setCurrentValue(WorldAddEmptyBoundaryAction::NAME, boundary);
  ActionRegistry::getInstance().getActionByName(WorldAddEmptyBoundaryAction::NAME)->call(Action::NonInteractive);
};

Dialog* WorldAddEmptyBoundaryAction::fillDialog(Dialog *dialog) {
  ASSERT(dialog,"No Dialog given when filling action dialog");

  dialog->queryVector(NAME, false, ValueStorage::getInstance().getDescription(NAME));

  return dialog;
}

Action::state_ptr WorldAddEmptyBoundaryAction::performCall() {
  Vector boundary;
  Vector Min;
  Vector Max;
  int j=0;

  ValueStorage::getInstance().queryCurrentValue(NAME, boundary);

  // get maximum and minimum
  vector<atom *> AllAtoms = World::getInstance().getAllAtoms();
  ASSERT(AllAtoms.size() > 0, "There must be atoms present for AddingEmptyBoundary.");
  vector<atom *>::iterator AtomRunner = AllAtoms.begin();
  Min = (*AtomRunner)->x;
  Max = (*AtomRunner)->x;
  for (; AtomRunner != AllAtoms.end(); ++AtomRunner) {
    for (int i=0;i<NDIM;i++) {
      if ((*AtomRunner)->x[i] > Max[i])
        Max[i] = (*AtomRunner)->x[i];
      if ((*AtomRunner)->x[i] < Min[i])
        Min[i] = (*AtomRunner)->x[i];
    }
  }
  // set new box size
  double * const cell_size = new double[6];
  for (j=0;j<6;j++)
    cell_size[j] = 0.;
  j=-1;
  for (int i=0;i<NDIM;i++) {
    j += i+1;
    cell_size[j] = (Max[i]-Min[i]+2.*boundary[i]);
  }
  World::getInstance().setDomain(cell_size);
  delete[] cell_size;
  // translate all atoms, such that Min is aty (0,0,0)
  AtomRunner = AllAtoms.begin();
  for (; AtomRunner != AllAtoms.end(); ++AtomRunner)
    (*AtomRunner)->x -= Min - boundary;
  return Action::success;
}

Action::state_ptr WorldAddEmptyBoundaryAction::performUndo(Action::state_ptr _state) {
//  ParserLoadXyzState *state = assert_cast<ParserLoadXyzState*>(_state.get());

  return Action::failure;
//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);
//
//  return Action::state_ptr(new ParserLoadXyzState(state->mol,newName));
}

Action::state_ptr WorldAddEmptyBoundaryAction::performRedo(Action::state_ptr _state){
  return Action::failure;
}

bool WorldAddEmptyBoundaryAction::canUndo() {
  return false;
}

bool WorldAddEmptyBoundaryAction::shouldUndo() {
  return false;
}

const string WorldAddEmptyBoundaryAction::getName() {
  return NAME;
}
