/*
 * OrthogonalSummation.hpp
 *
 *  Created on: Jun 25, 2012
 *      Author: heber
 */

#ifndef ORTHOGONALSUMMATION_HPP_
#define ORTHOGONALSUMMATION_HPP_


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <map>

#include "SetValue.hpp"
#include "SubsetMap.hpp"
#include "SetValueMap.hpp"

/** OrthogonalSummation is a functor executing an orthogonal summation of SetValue's
 * that are each associated to a certain IndexSet whose union is a SetOfIndexSets.
 *
 *  For the given class we require the following functions:
 *  -# operator=(): assignment operator for placement in vector
 *  -# operator+=(): addition operator for adding one instance from another
 *  -# operator-=(): subtraction operator for subtracting one instance from another
 *  -# operator<<(): output operator
 */
template <class T>
class OrthogonalSummation
{
public:
  typedef std::vector< IndexSet::ptr > InputSets_t;
  typedef std::vector< T > InputValues_t;
  OrthogonalSummation(InputSets_t &indices, InputValues_t& values, SubsetMap::ptr _subsetmap = SubsetMap::ptr());

  /** Performs the orthogonal summation and returns result.
   *
   * @param level sum up to this level
   * @return resulting value
   */
  T operator()(const size_t level) const;

  /** Returns const reference to internal setvalues.
   *
   * @return const reference to internal setvalues.
   */
  const SetValueMap<T> & getSetValues() const {
    return setvalues;
  }

private:
  T Sum(const size_t level) const;

private:
  //!> SubsetTree with the tree-like structure of subsets
  SubsetMap::ptr subsetmap;
  //!> set of all subset values
  SetValueMap<T> setvalues;
};

#include "OrthogonalSummation_impl.hpp"

#endif /* ORTHOGONALSUMMATION_HPP_ */
