/*
 * SubsetMap_Mock.hpp
 *
 *  Created on: Jul 4, 2012
 *      Author: heber
 */

#ifndef SUBSETMAP_MOCK_HPP_
#define SUBSETMAP_MOCK_HPP_


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <map>

#include "Fragmentation/Summation/IndexSet.hpp"
#include "Fragmentation/Summation/IndexSetContainer.hpp"


class LookupSubset {
  typedef std::map<IndexSet::ptr, IndexSetContainer::ptr > LookupMap_t;
public:
  LookupSubset()
  {}

  IndexSetContainer::ptr & getSubsets(const IndexSet::ptr &subset) {
    LookupMap_t::iterator iter = LookupMap.find(subset);
    if (iter == LookupMap.end())
      return empty_container;
    else
      return iter->second;
  }
  LookupMap_t LookupMap;
private:
  IndexSetContainer::ptr empty_container;
};


#endif /* SUBSETMAP_MOCK_HPP_ */
