/*
 * SetValueMap_Mock.hpp
 *
 *  Created on: Jul 4, 2012
 *      Author: heber
 */

#ifndef SETVALUEMAP_MOCK_HPP_
#define SETVALUEMAP_MOCK_HPP_


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <map>

#include "Fragmentation/Summation/IndexSet.hpp"
#include "Fragmentation/Summation/SetValue.hpp"

class LookupValue {
  typedef std::map<IndexSet::ptr, SetValue<int>::ptr > LookupMap_t;
public:
  LookupValue()
  {}

  SetValue<int>::ptr & getValue(const IndexSet::ptr &subset) {
    LookupMap_t::iterator iter = LookupMap.find(subset);
    if (iter == LookupMap.end())
      return null_ptr;
    else
      return iter->second;
  }
  LookupMap_t LookupMap;
private:
  SetValue<int>::ptr null_ptr;
};


#endif /* SETVALUEMAP_MOCK_HPP_ */
